function img  = imgCzp(radialFrequency,imSize)
% Create a Circular Zone Plate image

% imSize specifies the width and height of the image
% radialFrequency gives the number of cycles in the image
% along one axis


disp(['in imgCzp . . . .' num2str(radialFrequency) ' ' num2str(imSize)]);

%if ieNotDefined('radialFrequency'), radialFrequency = 24; end
%if ieNotDefined('imSize'),          imSize = 128; end

mx = round(imSize/2); mn = -(mx-1);
[x, y] = meshgrid(mn:mx, mn:mx);
l = (x == 0);
x(l) = eps;

r = x.^2 + y.^2;

img = cos(2*pi*(r)*radialFrequency/(imSize^2));
img(find(img <= 0)) = -1;
img(find(img >= 0)) = 1;

%figure;
%imagesc(img);
%colormap(gray);

img =  ieScale(img,1,256);

return;
